/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzer;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzerFactory;
import oracle.ops.verification.framework.util.VerificationUtil;

public class CheckMultUIDCommand
extends VerificationCommand {
    private static String m_arg = "-checkUID";
    private String m_userid;

    public CheckMultUIDCommand(String nodeName, String userID) {
        super(nodeName, null, null);
        this.m_userid = userID;
        String[] args = new String[]{m_arg, userID};
        super.setArgs(args);
    }

    @Override
    public boolean execute() {
        Trace.out((String)("CheckMultUIDCommand::Inside execute() " + Thread.currentThread().getName()));
        boolean bResult = super.execute();
        Result result = this.getResult();
        if (!bResult) {
            String trcTxt = "super.execute() failed for CheckMultUIDCommand...";
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            result.addErrorInfo("check for Multiple users  with UID " + this.m_userid + " failed");
            result.setStatus(2);
            return bResult;
        }
        String[] resultString = this.getCommandResult().getResultString();
        String reoutput = VerificationUtil.strArr2String(resultString);
        ExecutionAnalyzer analyzer = ExecutionAnalyzerFactory.getExecutionAnalyzer();
        return analyzer.verifyMultUser(reoutput, this.m_userid, result);
    }
}

